import matplotlib.pyplot as plt
import glob
import math
import numpy as np
from statsmodels.tsa.stattools import adfuller
from tqdm import tqdm


inDIR = input("Enter input directory: ")
outDIR = input("Enter output directory: ")
pThresh = float(input("Enter desired threshold: "))
Index = int(input("Enter column index with linear conductance values: "))

inDIR += "\*.txt"

inFileArray = []
inFileArray = glob.glob(inDIR)
#print(inFileArray[0])

N = len(inFileArray)


#for i in tqdm(range(0, N)):
for i in range(0, N):
#    pbar.update("\r")
    OpenFile = inFileArray[i]
    inFile = open(OpenFile, "r")
    G = inFile.readlines()

    Gvec = []
    GvecLog = []
        
    for x in G:
        place = []
        place = x.split()
        Gvec.append(place[Index])
    inFile.close()
    L = len(Gvec)
        
    np.seterr(divide = 'ignore')
        
    FloatingG = [float(k) for k in Gvec]
    AbsoluteG = [abs(k) for k in FloatingG]
    AbsGplus = [k + 1e-20 for k in AbsoluteG]
    GvecLog = [np.log10(k) for k in AbsGplus]

    ADF_Output = adfuller(GvecLog)
    ADF_pVal = float(ADF_Output[1])
    #print(ADF_pVal)
    
    if ADF_pVal > pThresh:
        continue
    else:

        TempOutDIR = outDIR
        
        TempOutDIR += "\File"
        TempOutDIR += "{:0>6}".format(i)
        TempOutDIR += ".txt"
            
        OutputFile = open(TempOutDIR, "w")

        for j in range(0, L):
            OutputFile.write(Gvec[j])
            OutputFile.write("\t")
            OutputFile.write(ADF_pVal)
            OutputFile.write("\n")
                
        OutputFile.close()

print("DONE!")
